<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
require('fpdf/fpdf.php');
require('FPDI/src/autoload.php');

use \setasign\Fpdi\Fpdi;

// Array of PDF files to merge
$pdfFiles = array('TestPDFfile1.pdf', 'TestPDFfile.pdf');

// Create a new instance of FPDI
$pdf = new Fpdi();

// Iterate through each PDF file
foreach ($pdfFiles as $file) {
    // Check if the file exists
    if (file_exists($file)) {
        // Add a new page to the output PDF
        $pdf->AddPage();

        // Import the pages from the source PDF
        $pages = $pdf->setSourceFile($file);

        // Iterate through each page and add it to the output PDF
        for ($pageNumber = 1; $pageNumber <= $pages; $pageNumber++) {
            $templateId = $pdf->importPage($pageNumber);
            $pdf->useTemplate($templateId);
        }
    } else {
        echo "File not found: " . $file . "\n";
    }
}

// Output the merged PDF
$pdf->Output('merged.pdf', 'F');
?>