$(document).ready(function() {
   
var company_id = $("#company_id").val();
var lang = $("#lang").val();
var em_type = $("#em_type").val();

    // Check browser support for the Web Speech API
    if ('webkitSpeechRecognition' in window) {
        var recognition = new webkitSpeechRecognition();
        
        // Set recognition options
        recognition.continuous = true; // Keep listening for speech until stopped
        recognition.interimResults = true; // Get interim results as the user speaks
        
        // Handle recognition result
        recognition.onresult = function(event) {
            var result = event.results[event.results.length - 1][0].transcript;
            $('#result').text(result);
            //alert(result);
            $.ajax({
                url: "Employ_Search_Filterr.php",
                type: "POST",
                data: {
                    result: result,
                    company_id: company_id,
                    lang: lang,
                    em_type:em_type
                    
                },
                cache: false,
                success: function(dataResult){
                    
                    $('.staff-grid-row').html(dataResult);
                    recognition.stop();	
                }
            });
        
        };
        
        // Handle recognition error
        recognition.onerror = function(event) {
            console.error('Recognition error:', event.error);
        };
        
        // Start the speech recognition process
        $('#startButton').click(function() {
            recognition.start();
        });
    } else {
        console.error('Web Speech API is not supported in this browser.');
    }
});