<!DOCTYPE html>
<html>
<head>
  <title>PDF Text Extraction</title>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/pdf.js/2.10.377/pdf.min.js"></script>
</head>
<body>
  <input type="file" id="pdfFile" accept=".pdf"  onchange="extractText()"/>
  <button onclick="extractText()">Extract Text</button>
  <div id="textContainer"></div>

  <script>
    function extractText() {
      const fileInput = document.getElementById('pdfFile');
      const file = fileInput.files[0];

      if (file) {
        const reader = new FileReader();

        reader.onload = function(event) {
          const typedArray = new Uint8Array(event.target.result);
          const loadingTask = pdfjsLib.getDocument(typedArray);
          
          loadingTask.promise.then((pdf) => {
            const textContent = [];

            for (let pageNumber = 1; pageNumber <= pdf.numPages; pageNumber++) {
              pdf.getPage(pageNumber).then((page) => {
                page.getTextContent().then((content) => {
                  const pageText = content.items.map((item) => item.str).join(' ');
                  textContent.push(pageText);

                  if (textContent.length === pdf.numPages) {
                    const textContainer = document.getElementById('textContainer');
                    textContainer.textContent = textContent.join(' ');
                    const extractedText = textContent.join(' ');
                    alert(extractedText);
                    const searchText = '5746.37';
                    const formattedSearchText = searchText.replace(/,/g, '');
                const regex = new RegExp('\\b' + formattedSearchText + '\\b');
if (regex.test(extractedText)) {
    alert(`The text "${searchText}" was found in the extracted text.`);
} else {
    alert(`The text "${searchText}" was not found in the extracted text.`);
}
                  }
                });
              });
            }
          }).catch((error) => {
            console.error('Error loading PDF:', error);
          });
        };

        reader.readAsArrayBuffer(file);
      }
    }
  </script>
</body>
</html>