


<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>بحث داخل القوائم المنسدلة</title>
    
     <style>
        /* تنسيق حقل البحث */
        input[type="text"] {
            width: 100%;
            padding: 8px;
            margin: 5px 0 10px 0;
            box-sizing: border-box;
            border: 2px solid #ccc;
            border-radius: 4px;
            font-size: 16px;
        }

        /* تنسيق القائمة المنسدلة */
        select {
            width: 100%;
            padding: 10px;
            margin: 5px 0 20px 0;
            border: 2px solid #ccc;
            border-radius: 4px;
            background-color: #fff;
            font-size: 16px;
            cursor: pointer;
        }

        /* تنسيق عند التفاعل مع القائمة المنسدلة */
        select:focus {
            border-color: #FF9F43;
            outline: none;
        }

        /* تنسيق القسم الخاص بالقائمة المنسدلة وحقل البحث */
        .select-container {
            margin-bottom: 20px;
        }

        /* تنسيق تسمية الحقل */
        label {
            font-size: 16px;
            font-weight: bold;
            margin-bottom: 5px;
            display: block;
        }
    </style>
    
</head>
<body>

<label for="clientSelect">العملاء:</label>
<input type="text" id="clientSearch" placeholder="ابحث عن عميل..." onkeyup="filterOptions('clientSelect', 'clientSearch')">
<select id="clientSelect" name="client">
    <option value="client1">عميل 1</option>
    <option value="client2">عميل 2</option>
    <option value="client3">عميل 3</option>
    <!-- المزيد من العملاء -->
</select>

<label for="citySelect">المدينة:</label>
<input type="text" id="citySearch" placeholder="ابحث عن مدينة..." onkeyup="filterOptions('citySelect', 'citySearch')">
<select id="citySelect" name="city">
    <option value="city1">مدينة 1</option>
    <option value="city2">مدينة 2</option>
    <option value="city3">مدينة 3</option>
    <!-- المزيد من المدن -->
</select>

<label for="portSelect">المنفذ:</label>
<input type="text" id="portSearch" placeholder="ابحث عن منفذ..." onkeyup="filterOptions('portSelect', 'portSearch')">
<select id="portSelect" name="port">
    <option value="port1">منفذ 1</option>
    <option value="port2">منفذ 2</option>
    <option value="port3">منفذ 3</option>
    <!-- المزيد من المنافذ -->
</select>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>
function filterOptions(selectId, searchInputId) {
    var input, filter, select, options, i;
    input = document.getElementById(searchInputId);
    filter = input.value.toLowerCase();
    select = document.getElementById(selectId);
    options = select.getElementsByTagName("option");

    for (i = 0; i < options.length; i++) {
        txtValue = options[i].textContent || options[i].innerText;
        if (txtValue.toLowerCase().indexOf(filter) > -1) {
            options[i].style.display = "";
        } else {
            options[i].style.display = "none";
        }
    }
}
</script>

</body>
</html>



