<!DOCTYPE html>
<html>
<head>
  <title>Merge PDF Files</title>
</head>
<body>
  <h1>Merge PDF Files</h1>
  <form id="pdfForm" action="merge.php" method="POST" enctype="multipart/form-data">
    <input type="file" name="pdf[]" multiple accept=".pdf" />
    <button type="submit">Merge PDFs</button>
  </form>
<script src="https://unpkg.com/pdf-lib"></script>
<script>
 document.getElementById('pdfForm').addEventListener('submit', function (e) {
  e.preventDefault();
  var form = e.target;
  var formData = new FormData(form);

  // Send merged PDF file to the server
  fetch(form.action, {
    method: 'POST',
    body: formData
  })
    .then(response => {
      if (!response.ok) {
        throw new Error('Network response was not OK');
      }
      return response.json();
    })
    .then(data => {
      if (data.success) {
        alert(data.message);
      } else {
        alert('An error occurred while merging PDF files1.');
      }
    })
    .catch(error => {
      console.error('Error:', error);
      alert('An error occurred while merging PDF files.');
    });
});
</script>
</body>
</html>