<!-- (A) LOAD TESSERACT -->
<!-- https://cdnjs.com/libraries/tesseract.js -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/tesseract.js/4.1.1/tesseract.min.js"></script>
 
<!-- (B) FILE SELECTOR & RESULT -->
<input type="file" id="select" accept="image/png, image/gif, image/webp, image/jpeg">
<textarea id="result" style="width:500px;height:500px"></textarea>
<script>
    window.addEventListener("load", async () => {
  // (A) GET HTML ELEMENTS
  const hSel = document.getElementById("select"),
        hRes = document.getElementById("result");
 
  // (B) CREATE ENGLISH TESSERACT WORKER
  const worker = await Tesseract.createWorker();
  await worker.loadLanguage("eng");
  await worker.initialize("eng");
 
  // (C) ON FILE SELECT - IMAGE TO TEXT
  hSel.onchange = async () => {
   
    const res = await worker.recognize(hSel.files[0]);
    alert(res.data.text);
    var text = res.data.text;
    var tx = '5,746.37';
    const convertedNumberString = tx.replace(/,/g, ".");
    const isWordPresent = text.includes(convertedNumberString);
    alert(isWordPresent);
    hRes.value = res.data.text;

  };
});
</script>