<!DOCTYPE html>
<html>
<head>
	<title>Select with Checkbox Example</title>
	<style>
		.dropdown {
			position: relative;
			display: inline-block;
		}
		
		.dropdown-content {
			display: none;
			position: absolute;
			z-index: 1;
			background-color: #f9f9f9;
			min-width: 160px;
			box-shadow: 0px 8px 16px 0px rgba(0,0,0,0.2);
			padding: 12px 16px;
			border-radius: 5px;
		}
		
		.dropdown:hover .dropdown-content {
			display: block;
		}
		
		.dropdown-checkbox label {
			display: block;
			margin-bottom: 10px;
		}
		
		.dropdown-checkbox input[type="checkbox"] {
			margin-right: 10px;
		}
		
		.selected-items {
			margin-top: 10px;
			font-weight: bold;
		}
	</style>
</head>
<body>
	<div class="dropdown dropdown-checkbox">
		<button>Choose Options</button>
		<div class="dropdown-content">
			<label>
				<input type="checkbox" name="option1" value="Option 1">Option 1
			</label>
			<label>
				<input type="checkbox" name="option2" value="Option 2">Option 2
			</label>
			<label>
				<input type="checkbox" name="option3" value="Option 3">Option 3
			</label>
			<button type="button" onclick="getSelectedItems()">Apply</button>
		</div>
	</div>
	
	<div class="selected-items"></div>
	
	<script>
		function getSelectedItems() {
			const dropdown = document.querySelector(".dropdown-checkbox");
			const checkboxes = dropdown.querySelectorAll('input[type="checkbox"]');
			const selectedItems = [];
			
			for (let i = 0; i < checkboxes.length; i++) {
				if (checkboxes[i].checked) {
					selectedItems.push(checkboxes[i].value);
				}
			}
			
			const selectedItemsElement = document.querySelector(".selected-items");
			selectedItemsElement.innerHTML = "Selected options: " + selectedItems.join(", ");
		}
	</script>
</body>
</html>