<?php 
function getVacationAcceptLevel($numDays, $advanceDays) {
  $levels = array(
    array("name" => "Level 1", "minDays" => 1, "maxDays" => 3, "minAdvanceDays" => 14),
    array("name" => "Level 2", "minDays" => 1, "maxDays" => 3, "minAdvanceDays" => 0),
    array("name" => "Level 3", "minDays" => 4, "maxDays" => 7, "minAdvanceDays" => 21),
    array("name" => "Level 4", "minDays" => 4, "maxDays" => 7, "minAdvanceDays" => 0),
    array("name" => "Level 5", "minDays" => 8, "maxDays" => 14, "minAdvanceDays" => 28),
    array("name" => "Level 6", "minDays" => 8, "maxDays" => 14, "minAdvanceDays" => 0),
    array("name" => "Level 7", "minDays" => 15, "maxDays" => 21, "minAdvanceDays" => 35),
    array("name" => "Level 8", "minDays" => 15, "maxDays" => 21, "minAdvanceDays" => 0),
    array("name" => "Level 9", "minDays" => 22, "maxDays" => 365, "minAdvanceDays" => 42)
  );

  foreach ($levels as $level) {
    if ($numDays >= $level["minDays"] && $numDays <= $level["maxDays"] && $advanceDays >= $level["minAdvanceDays"]) {
      return $level["name"];
    }
  }

  return "Invalid number of days or advance days";
}
$numDays = 1; // Assuming you are getting the number of days from a form
$advanceDays = 7; // Assuming you are getting the advance days from a form
$acceptLevel = getVacationAcceptLevel($numDays, $advanceDays);
echo "Vacation accept level: " . $acceptLevel;
?>